#include "border.h"

Z80EX_BYTE C_Border::portFB;
SNDRENDER C_Border::spkRender; //[boo]
SNDSAMPLE C_Border::soundBuffer[MAX_SPEAKER_BUFFER_SIZE];
int C_Border::samples;
unsigned C_Border::oldSndVal;

void C_Border::Init(void)
{
	AttachZ80OutputHandler(OnOutputByte);

	AttachFrameStartHandler(OnFrameStart);			// [boo]
	AttachAfterFrameRenderHandler(OnAfterFrameRender);	// [boo]

	portFB = 0;
	samples = 0;	// [boo]
	oldSndVal = 0;
}

void C_Border::Close(void)
{
}

bool C_Border::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if (port & 1) return false;

	if (!params.maxSpeed && params.sound)
	{
		bool chSnd = ((value & 0x10) != (portFB & 0x10));
		bool chTap = ((value & 8) != (portFB & 8));

		if (chSnd || chTap)
		{
			unsigned val = (oldSndVal ? 0 : MAX_SPK_VOL);
			spkRender.update(devClk, val, val);
			oldSndVal = val;
		}
	}

	portFB = value;
	return true;
}

// [boo]
void C_Border::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound) {
		spkRender.start_frame(&soundBuffer[samples]);	// [boo]
	}
}

void C_Border::OnAfterFrameRender(void)
{
	if (!params.maxSpeed && params.sound) {
		samples += spkRender.end_frame(lastDevClk);	// [boo]
		if (samples >= MAX_SPEAKER_BUFFER_SIZE) StrikeError("Memory corruption in C_Border::OnAfterFrameRender");
	}
}
// [/boo]

