//[boo_boo]

#include "kempston.h"
#include "../../joystick_manager.h"

int C_KempstonStick::joy_num=-1;

void C_KempstonStick::Init(void)
{
	AttachZ80InputHandler(OnInputByte);
}

void C_KempstonStick::Close(void)
{
}

void C_KempstonStick::SetJoyNum(int num)
{
	joy_num = num;
}

bool C_KempstonStick::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if(!(port & 0x20))
	{
		if(joy_num >= 0)
		{
			retval = 0;
			JoystickState *jstate = C_JoystickManager::Instance()->GetJoystickState(joy_num);
			
			if(jstate->right) retval |= 0x1;
			if(jstate->left) retval |= 0x2;
			if(jstate->down) retval |= 0x4;
			if(jstate->up) retval |= 0x8;
			if(jstate->fire) retval |= 0x10;
			
			return true;
		}
	}

	return false;
}
