#include "tsfm.h"
#include "../../bin.h"

#define CHIP_FLAG_MASK 1
#define STATUS_FLAG_MASK 2
#define FM_FLAG_MASK 4

#define CHIP_NUM ((pseudoReg & CHIP_FLAG_MASK) ? 1 : 0)

C_Ym2203Chip C_TsFm::ym2203Chip[TSFM_CHIPS_COUNT];
SNDCHIP C_TsFm::ayChip[TSFM_CHIPS_COUNT];
int C_TsFm::pseudoReg;
int C_TsFm::selectedReg;

short int C_TsFm::ym2203Buffer[MAX_YM2203_BUFFER_SIZE];
SNDSAMPLE C_TsFm::ayBuffer[TSFM_CHIPS_COUNT][MAX_AY_BUFFER_SIZE];

SNDSAMPLE C_TsFm::soundBuffer[MAX_TSFM_BUFFER_SIZE];
int C_TsFm::samples;

void C_TsFm::Init(void)
{
	pseudoReg = 7;
	selectedReg = 0;

	AttachZ80InputHandler(OnInputByte);
	AttachZ80OutputHandler(OnOutputByte);
	AttachFrameStartHandler(OnFrameStart);
	AttachAfterFrameRenderHandler(OnAfterFrameRender);
	AttachResetHandler(OnReset);
	samples = 0;
}

void C_TsFm::Close(void)
{
}

bool C_TsFm::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		if ( !(pseudoReg & STATUS_FLAG_MASK) && !(pseudoReg & FM_FLAG_MASK) ) {
			retval = ym2203Chip[CHIP_NUM].ReadStatus();
		} else {
			retval = (selectedReg < 0x10) ? ayChip[CHIP_NUM].read() : ym2203Chip[CHIP_NUM].Read();
		}

		return true;
	}

	return false;
}

bool C_TsFm::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		if ((value & BIN(0x11111000)) == BIN(0x11111000))
		{
			pseudoReg = value & 7;
			return true;
		}

		if (value < 0x10) {
			ayChip[CHIP_NUM].select(value);
		} else {
			ym2203Chip[CHIP_NUM].Select(value);
		}

		selectedReg = value;
		return true;
	}

	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x10000000),BIN(0x00000000)))	// 0xBFFD
	{
		if (selectedReg < 0x10) {
			ayChip[CHIP_NUM].write((!params.sound || params.maxSpeed) ? 0 : devClk, value);
		} else {
			ym2203Chip[CHIP_NUM].Write(value);
		}

		return true;
	}

	return false;
}

void C_TsFm::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound)
	{
		ayChip[0].start_frame(&ayBuffer[0][0]);
		ayChip[1].start_frame(&ayBuffer[1][0]);
	}
}

void C_TsFm::OnAfterFrameRender(void)
{
	if (!params.maxSpeed && params.sound)
	{
		int frameSamples = ayChip[0].end_frame(lastDevClk);
		int aySamples = ayChip[1].end_frame(lastDevClk);

		if (frameSamples != aySamples) StrikeError("Internal error in C_TsFm::OnAfterFrameRender");

		if (!(pseudoReg & FM_FLAG_MASK))
		{
			memset(ym2203Buffer, 0, frameSamples * sizeof(short int));
			ym2203Chip[0].Render(ym2203Buffer, frameSamples);
			ym2203Chip[1].Render(ym2203Buffer, frameSamples);

			short int* a = ym2203Buffer;;
			SNDSAMPLE* b = &ayBuffer[0][0];
			SNDSAMPLE* c = &ayBuffer[1][0];
			SNDSAMPLE* r = &soundBuffer[samples];

			for (int sz = frameSamples; sz--;)
			{
				unsigned short fm = ((*a) / 2) + 0x7FFF;

				r->ch.left = b->ch.left + c->ch.left + fm;
				r->ch.right = b->ch.right + c->ch.right + fm;

				a++; b++; c++; r++;
			}
		}
		else
		{
			SNDSAMPLE* b = &ayBuffer[0][0];
			SNDSAMPLE* c = &ayBuffer[1][0];
			SNDSAMPLE* r = &soundBuffer[samples];

			for (int sz = frameSamples; sz--;)
			{
				r->ch.left = b->ch.left + c->ch.left;
				r->ch.right = b->ch.right + c->ch.right;

				b++; c++; r++;
			}
		}

		samples += frameSamples;
		if (samples >= MAX_YM2203_BUFFER_SIZE) StrikeError("Memory corruption in C_TsFm::OnAfterFrameRender");
	}
}

void C_TsFm::OnReset(void)
{
	ayChip[0].reset();
	ayChip[1].reset();
	ym2203Chip[0].Reset();
	ym2203Chip[1].Reset();

	pseudoReg = 7;
	selectedReg = 0;
}
