#ifndef _YM2203_H_INCLUDED_
#define _YM2203_H_INCLUDED_

#include "../../zemu.h"
#include "../device.h"
#include "../../lib_ay/sndchip.h"
#include "../../lib_ay/sndrender.h"
#include "../../lib_ym2203/ym2203_chip.h"

#define TSFM_CHIPS_COUNT 2
#define MAX_AY_BUFFER_SIZE 2048
#define MAX_YM2203_BUFFER_SIZE 1024
#define MAX_TSFM_BUFFER_SIZE 2048

class C_TsFm : public C_Device
{
	public:

	static C_Ym2203Chip ym2203Chip[TSFM_CHIPS_COUNT];
	static SNDCHIP ayChip[TSFM_CHIPS_COUNT];

	void Init(void);
	void Close(void);

	static bool OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval);
	static bool OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value);
	static void OnFrameStart(void);
	static void OnAfterFrameRender(void);
	static void OnReset(void);

	static int pseudoReg;
	static int selectedReg;

	static short int ym2203Buffer[MAX_YM2203_BUFFER_SIZE];
	static SNDSAMPLE ayBuffer[TSFM_CHIPS_COUNT][MAX_AY_BUFFER_SIZE];

	static SNDSAMPLE soundBuffer[MAX_TSFM_BUFFER_SIZE];
	static int samples;
};

#endif
