#ifdef OS_LINUX

#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
#include <math.h>

int audio;

void wav_start(unsigned frag_num, unsigned frag_size)
{
	int tmp;

	audio = open("/dev/dsp", O_WRONLY, 0);
	if (audio == -1) StrikeError("Unable to open /dev/dsp for writing.");

	tmp = (frag_num << 16) | (int)ceil(log2(frag_size));

	if (ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &tmp) == -1) {close(audio); StrikeError("Unable to set audio fragment size.");}

	tmp = AFMT_S16_LE;
	if (ioctl(audio,SNDCTL_DSP_SETFMT,&tmp) == -1) {close(audio); StrikeError("setting SNDCTL_DSP_SETFMT on audiodev failed.");}

	tmp = 16;
	ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp);
	if (tmp != 16) StrikeError("Unable set samplesize = %d.", tmp);

	tmp = 1;
	if (ioctl(audio, SNDCTL_DSP_STEREO, &tmp) == -1) {close(audio); StrikeError("Unable to set stereo.");}

	tmp = SND_FQ;
	if (ioctl (audio, SNDCTL_DSP_SPEED, &tmp) == -1) {close(audio); StrikeError("Unable to set audio speed = %d.",SND_FQ);}
}

void wav_play(SNDSAMPLE *buf, unsigned nsamples)
{
	unsigned spbsize = nsamples * sizeof(SNDSAMPLE);
	if (write(audio, buf, spbsize) != spbsize) printf("Write to soundcard device failed\n");
}

void wav_stop()
{
	close(audio);	
}

#endif
