#ifndef _TAPE_H_INCLUDED_
#define _TAPE_H_INCLUDED_

#include "../zemu.h"

class C_Tape
{
	public:

	static unsigned long long prevDevClkCounter;
	static int tapeBit;
	static int state;
	static int counter;
	static BYTE *data;
	static long size;

	static long blockPos;
	static int blockSize;
	static int posInBlock;
	static BYTE currentByte;
	static int delay;

	static void Close(void);

	static int GetCurrBit(void);
	static void Process(void);
	static bool ProcessTicks(unsigned long long ticks);

	static bool IsLoaded(void);
	static bool IsActive(void);
	static unsigned int GetPosPerc(void);

	static void Eject(void);
	static bool Insert(const char *fname);
	static void Start(void);
	static void Stop(void);
	static void Rewind(void);

	static BYTE Data(long pos);
};

#endif

