#ifndef _ZEMU_H_INCLUDED_
#define _ZEMU_H_INCLUDED_

#include "defines.h"
#include "SDL.h"
#include "lib_z80ex/z80ex.h"
#include "lib_ay/sndrender.h"
#include "config.h"

#define WIDTH 320
#define HEIGHT 240

#define FRAME_WAIT_MS 1
#define MAX_SPEED_FRAME_SKIP 128

#define AUDIO_HW_BUFFER 1024
#define MIX_BUFFER_SIZE 2048
#define SOUND_BUFFER_SIZE ((MIX_BUFFER_SIZE)*2)		// for lib_ay

#define MAX_TRACE_FORMAT 0x100

//[boo_boo]
#define MAX_JOYSTICKS 5
#define DEF_JOY_AXIS_TRESHOLD 3200 //default axis movement treshold (useful for fine-tunung analog sticks)

struct s_Action
{
	const char *name;
	void (* action)(void);
};

struct s_Params
{
	bool useFlipSurface;
	bool fullscreen;
	bool scale2x;
	bool scanlines;
	bool sound;
	bool maxSpeed;
	bool antiFlicker;
	bool sdl_sound;
	int mouseDiv;
	bool showInactiveIcons;
	char arcPluginsDir[MAX_PATH];
	int soundParam;
	bool cpuTraceEnabled;
	char cpuTraceFormat[MAX_TRACE_FORMAT];
	char cpuTraceFileName[MAX_PATH];
	//[boo_boo]
	bool KempstonEnable;
	int KempstonOnStickNum;
	int KempstonAxisTreshold;
};

extern C_Config config;
extern Z80EX_CONTEXT *cpu;
extern unsigned long long clk, devClk, lastDevClk, devClkCounter;
extern s_Params params;
extern SDL_Surface *screen;
extern int PITCH;
extern bool drawFrame;
extern int frames;
extern bool disableSound;
extern char tempFolderName[MAX_PATH];

extern s_Action cfgActions[];

//--------------------------------------------------------------------------------------------------------------

#define MAX_HANDLERS 64

void AttachZ80ReadHandler(bool (* func)(Z80EX_WORD, bool, Z80EX_BYTE&));
void AttachZ80WriteHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE));
void AttachZ80InputHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE&));
void AttachZ80OutputHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE));
void AttachFrameStartHandler(void (* func)(void));
void AttachAfterFrameRenderHandler(void (* func)(void));
void AttachSDLHandler(int eventType, bool (* func)(SDL_Event&));
void AttachResetHandler(void (* func)(void));

//--------------------------------------------------------------------------------------------------------------

extern bool attributesHack;
extern int* colors;
extern int turboMultiplierNx;

//--------------------------------------------------------------------------------------------------------------

extern Z80EX_WORD lastCommandAddr;
extern bool breakpoints[0x10000];

Z80EX_BYTE ReadByteDasm(Z80EX_WORD addr, void *userData);
void DebugStep(void);

//--------------------------------------------------------------------------------------------------------------

void TryNLoadFile(char *fname);
void TryNLoadFile(char *fname, int drive);
void ScaleImage(void);

//--------------------------------------------------------------------------------------------------------------

void UpdateScreen(void);

//--------------------------------------------------------------------------------------------------------------

#endif
