<?php
/*************************************************************************

 rss.php
 Exporting messages form vBulletin forum into RSS2

 Written by Andrew nyuk Marinow, 2005
 Based on vBulletin 3.0.3
 Copyright c2000-2004 Jelsoft Enterprises Ltd. All Rights Reserved.

 ver 0.3 beta /2005-05-27/

*************************************************************************/ 

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('SESSION_BYPASS', 1);
define('LOCATION_BYPASS', 1);
define('DIE_QUIETLY', 1);
define('THIS_SCRIPT', 'rss');
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();
// get special data templates from the datastore
$specialtemplates = array('userstats','birthdays','maxloggedin');
// pre-cache templates used by all actions
$globaltemplates = array();
// pre-cache templates used by specific actions
$actiontemplates = array();
// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_external.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Define main variables

define('ME', 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);

$get_type = @$_GET['type'];
$get_thread = intval($_GET['t']);

$max_limit = 100;   // Maximum posts fetch
$def_limit = 20;    // Posts limit by default

// Set posts limit
$limit = intval(@$_GET['n']);
if ($limit < 1) $limit = $def_limit;
if ($limit > $max_limit) $limit = $max_limit;

// set us up as a very limited privileges user
$vboptions['hourdiff'] = (date('Z', TIMENOW) / 3600 - intval($_REQUEST['timeoffset'])) * 3600;
$bbuserinfo = array('usergroupid' => 1);
$usergroupcache = array();
$permissions = cache_permissions($bbuserinfo);

foreach (array_keys($forumcache) AS $forumid) {
    $fp = &$bbuserinfo['forumpermissions']["$forumid"];
    if ($fp & CANVIEW AND $fp & CANVIEWOTHERS)
        $forumchoice[] = $forumid;
}


// Do custon forum choice
if (@$_GET['xf']) {
    $custom_xfc = array();
    $xf = str_replace(' ', '', $_GET['xf']);
    $custom_xfc = explode(',', $xf);

    foreach ($custom_xfc as $tmp) 
        if ($tmp && ($r = array_search(intval($tmp), $forumchoice)) !== NULL) 
            unset($forumchoice[$r]);
}
elseif (@$_GET['f']) {
    $custom_forumchoice = array();

    $f = str_replace(' ', '', $_GET['f']);
    $custom_fc = explode(',', $f);

    foreach ($custom_fc as $tmp) 
        if (in_array(intval($tmp), $forumchoice))
            $custom_forumchoice[] = intval($tmp);

    if (!empty($custom_forumchoice)) 
        $forumchoice = $custom_forumchoice;
}

    
if (!empty($forumchoice)) {
    $forumchoice = 'AND thread.forumid IN(' . implode(',', $forumchoice) . ')';


    if ($get_type == 'topics') 
        $threadchoice = ' AND post.parentid=0';
    elseif ($get_type == 'comments') 
        $threadchoice = ' AND post.parentid!=0 AND post.threadid='.$get_thread;
    else
        $threadchoice = '';


    // Do Conditional Get
    $result = $DB_site->query('SELECT IF (MAX(editlog.dateline) > MAX(post.dateline), MAX(editlog.dateline), MAX(post.dateline)) AS dateline FROM '.TABLE_PREFIX.'post AS post, '.TABLE_PREFIX.'editlog AS editlog INNER JOIN '.TABLE_PREFIX.'thread AS thread ON thread.threadid = post.threadid WHERE 1=1 '.$forumchoice.$threadchoice);
    $res = $DB_site->fetch_array($result);
    if ($last_check = fe_doConditionalGet($res['dateline']))
        $datechoice = ' AND (post.dateline > '.$last_check.' OR editlog.dateline > '.$last_check.')';
    else 
        $datechoice = '';

    $query = 'SELECT thread.threadid, thread.title, forum.forumid, forum.title AS forumtitle, 
        IF (editlog.dateline, editlog.dateline, post.dateline) AS dateline,
        post.postid, post.parentid, post.pagetext AS preview, 
        post.title AS posttitle, post.username AS postusername, post.attach
        FROM '.TABLE_PREFIX.'post AS post
        INNER JOIN '.TABLE_PREFIX.'thread AS thread USING (threadid)
        INNER JOIN '.TABLE_PREFIX.'forum AS forum USING (forumid)
        LEFT JOIN '.TABLE_PREFIX.'deletionlog AS deletionlog ON (deletionlog.primaryid = thread.threadid AND deletionlog.type = "thread")
        LEFT JOIN '.TABLE_PREFIX.'editlog AS editlog ON (editlog.postid = post.postid)
        WHERE 1=1 '.$forumchoice.$threadchoice.$datechoice.'
            AND thread.visible = 1 AND open <> 10 AND deletionlog.primaryid IS NULL
        ORDER BY dateline DESC LIMIT '.$limit.'
    ';

    $threads = $DB_site->query($query);

}

$threadcache = array();
while ($thread = $DB_site->fetch_array($threads)) { // fetch the threads
    $threadcache[] = $thread;
}

// setup the board title
if (empty($title))
    // just show board title
    $rss_title = htmlspecialchars_uni($vboptions['bbtitle']);
else
    // show board title plus selection
    $rss_title = htmlspecialchars_uni($vboptions['bbtitle'] . " - $title");

// set XML type and nocache headers
header('Content-Type: text/xml');
//header('Content-Type: text/plain');
header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Pragma: public');

echo '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n";

echo "<rss version=\"2.0\"
\txmlns:wfw=\"http://wellformedweb.org/CommentAPI/\"
\txmlns:dc=\"http://purl.org/dc/elements/1.1/\"
\txmlns:syn=\"http://purl.org/rss/1.0/modules/syndication/\"
\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\r\n\r\n";

echo "<channel>\r\n";
echo "\t<title>" . $rss_title . "</title>\r\n";
echo "\t<link>$vboptions[bburl]</link>\r\n";
echo "\t<description>".htmlspecialchars_uni($vboptions['description'])."</description>\r\n";

echo "\t<syn:updatePeriod>hourly</syn:updatePeriod>\r\n";
echo "\t<syn:updateFrequency>1</syn:updateFrequency>\r\n";
echo "\t<syn:updateBase>1970-01-01T00:00+00:00</syn:updateBase>\r\n";
echo "\t<language>$stylevar[languagecode]</language>\r\n";
echo "\t<generator>vBulletin</generator>\r\n";
echo "\t<pubDate>".date('r', TIMENOW)."</pubDate>\r\n";

// list returned threads
if (!empty($threadcache)) {
    foreach ($threadcache AS $thread) {
        $fp = &$bbuserinfo['forumpermissions']["$forumid"];

        $posttitle = ($thread[posttitle] && $thread[parentid]) ? '<h3>'.$thread[posttitle].'</h3>' : '';

        echo "\t<item>\r\n";
        echo "\t<category>".$thread[forumtitle]."</category>\r\n";
        echo "\t\t<title>$thread[title]</title>\r\n";
        echo "\t\t<link>$vboptions[bburl]/showthread.php?p=$thread[postid]&amp;#post$thread[postid]</link>\r\n";
        echo "\t\t<description><![CDATA[".$posttitle.fe_parse_msg($thread['preview'])."]]></description>\r\n";
        echo "\t\t<guid isPermaLink=\"false\">".$thread['postid'].':'.$thread['parentid'].':'.$thread['dateline']."</guid>\r\n";
        echo "\t\t<pubDate>".date('r', $thread['dateline'])."</pubDate>\r\n";
        echo "\t\t<author>$thread[postusername]</author>\r\n";

        echo "\t\t<comments>$vboptions[bburl]/showthread.php?p=$thread[postid]&amp;#post$thread[postid]</comments>\r\n";
       
        if ($get_type == 'topics')
            echo "\t\t<wfw:commentRss>\r\n\t\t\t".ME.'?type=comments&amp;t='.$thread[threadid]."\r\n\t\t</wfw:commentRss>\r\n";

        if ($thread['attach']) {

            $result = $DB_site->query('
                SELECT attachmentid AS id, filename, filesize
                FROM '.TABLE_PREFIX.'attachment WHERE postid='.$thread['postid']
            );
            // Fetching attaches
            while ($attach = $DB_site->fetch_array($result)) 
                echo "\t\t".'<enclosure url="'.$vboptions['bburl'].'/attachment.php?attachmentid='.$attach['id'].'" length="'.$attach['filesize'].'" type="applictaion/binary" />'."\r\n";
        }
        echo "\t</item>\r\n";
    }
}

echo "</channel>\r\n";
echo "</rss>";


//
// Parse message text to RSS feed
//
function fe_parse_msg ($msg) {
    global $vboptions;


    $msg = preg_replace('/&(?!#[0-9]+;)/si', '&amp;', $msg); // translates all non-unicode entities
    $msg = str_replace('<', '&lt;', $msg);
    $msg = str_replace('>', '&gt;', $msg);
    // Deal with newlines, tabs and multiple spaces
    $msg = str_replace("\r", '', $msg);
    $msg = str_replace("\n", '<br/>', $msg);
    $msg = str_replace("\t", '&nbsp;&nbsp;', $msg);
    $msg = str_replace('  ', '&nbsp;&nbsp;', $msg);

    if (strpos($msg, '[') !== false && strpos($msg, ']') !== false) {
        $pattern = array("#\[b\](.*?)\[/b\]#si",
                         "#\[i\](.*?)\[/i\]#si",
                         "#\[u\](.*?)\[/u\]#si",
                         "#\[color=([a-zA-Z]*|\#?[0-9a-fA-F]{6})]#si",
                         "#\[/color\]#si",
                         "#\[size=(.*?)\]#si",
                         "#\[/size\]#si",
                         "#\[font=(.*?)\]#si",
                         "#\[/font\]#si",
                         "#\[highlight\](.*?)\[/highlight\]#si",
                         "#\[left\](.*?)\[/left\]#si",
                         "#\[center\](.*?)\[/center\]#si",
                         "#\[right\](.*?)\[/right\]#si",
                         "#\[indent\](.*?)\[/indent\]#si",
                         "#\[img\](.*?)\[/img\]#si",
                         "#\[url\](\"?)(.*?)(\"?)\[/url\]#ie",
                         "#\[url=(\"?)(.*?)(\"?)\](.*?)\[/url\]#ie",
                         "#\[email\](\"?)(.*?)(\"?)\[/email\]#i",
                         "#\[email=(\"?)(.*?)(\"?)\](.*?)\[/email\]#i",
                         "#\[thread\](.*?)\[/thread\]#i",
                         "#\[thread=(.*?)\](.*?)\[/thread\]#i",
                         "#\[post\](.*?)\[/post\]#i",
                         "#\[post=(.*?)\](.*?)\[/post\]#i",
                         "#\[list\](<br/>)?(.*?)\[/list\](<br/>)?#i",
                         "#\[list=(.*?)\](<br/>)?(.*?)\[/list\](<br/>)?#i",
                         "#\[\*\](.*?)<br/>#si",
                         "#\[code\](<br/>)?(.*?)(<br/>)?\[/code\]#si",
                         "#\[html\](<br/>)?(.*?)(<br/>)?\[/html\]#si",
                         "#\[php\](<br/>)?(.*?)(<br/>)?\[/php\]#si",
                         "#\[quote\]#si",
                         "#\[quote=(.*?)\]#si",
                         "#\[/quote\]#si"
                    );

        $replace = array('<b>$1</b>',
                         '<i>$1</i>',
                         '<u>$1</u>',
                         '<span style="color: $1">',            // [color]
                         '</span>',                             // [color]
                         '<font size="$1">',                    // [size]
                         '</font>',                             // [size]
                         '<font face="$1">'         ,           // [font]
                         '</font>',                             // [font]
                         '<em>$1</em>',                         // [highlight]
                         '<div align="left">$1</div>',          // [left]
                         '<div align="center">$1</div>',        // [center]
                         '<div align="right">$1</div>',         // [right]
                         '<strong>$1</strong>',                 // [indent]
                         '<img src="$1"/>',                     // [img]
                         'fe_truncate_url("$2")',               // [url]
                         'fe_truncate_url("$2", "$4")',         // [url]
                         '<a href="mailto:$2">$2</a>',                 // [email]
                         '<a href="mailto:$2">$4</a>',                 // [email]
                         '<a href="'.$vboptions[bburl].'/showthread.php?t=$1" target="_blank">'.$vboptions[bburl].'/showthread.php?t=$1</a>',
                         '<a href="'.$vboptions[bburl].'/showthread.php?t=$1" target="_blank">$2</a>',
                         '<a href="'.$vboptions[bburl].'/showthread.php?p=$1#post$1" target="_blank">'.$vboptions[bburl].'/showthread.php?p=$1#post$1</a>',
                         '<a href="'.$vboptions[bburl].'/showthread.php?p=$1#post$1" target="_blank">$2</a>',
                         '<ul>$2</ul>',                         // [list]
                         '<ol type="$1">$3</ol>',               // [list]
                         '<li>$1</li>',                         // [*]

                         '<pre><code>$2</code></pre>',          // [code]
                         '<pre><code>$2</code></pre>',          // [html]
                         '<pre><code>$2</code></pre>',          // [php]
                         '<blockquote>',                        // [quote]
                         '<blockquote><b>$1 wrote:</b><br/>',   // [quote]
                         '</blockquote>'                        // [/quote]
                    );

        // Run this big regex replacement
        $msg = preg_replace($pattern, $replace, $msg);
    }

    return $msg;
}

//
// Truncate URL if longer than 55 characters (add http:// or ftp:// if missing)
//
function fe_truncate_url($url, $link = '') {

    $full_url = $url;
    if (strpos($url, 'www.') === 0)
        $full_url = 'http://'.$full_url;
    else if (strpos($url, 'ftp.') === 0)
        $full_url = 'ftp://'.$full_url;

    // Ok, not very pretty :-)
    $link = ($link == '' || $link == $url) ? ((strlen($url) > 55) ? substr($url, 0 , 39).' ... '.substr($url, -10) : $url) : stripslashes($link);

    return '<a href="'.$full_url.'">'.$link.'</a>';
}

// A PHP implementation of conditional get, see 
//   http://fishbowl.pastiche.org/archives/001132.html
function fe_doConditionalGet ($timestamp) {
    $last_modified = substr(date('r', $timestamp), 0, -5).'GMT';
    $etag = '"'.md5($last_modified).'"';

    // Send the headers
    header("Last-Modified: $last_modified");
    header("ETag: $etag");

    // See if the client has provided the required headers
    $if_modified_since = isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) ?
        stripslashes($_SERVER['HTTP_IF_MODIFIED_SINCE']) :
        false;
    $if_none_match = isset($_SERVER['HTTP_IF_NONE_MATCH']) ?
        stripslashes($_SERVER['HTTP_IF_NONE_MATCH']) : 
        false;
    if (!$if_modified_since && !$if_none_match) {
        return false;
    }

    $last_check = strtotime(substr($if_modified_since, 0, -4));

    // At least one of the headers is there - check them
    if ($if_none_match && $if_none_match != $etag) {
        return $last_check; // etag is there but doesn't match
    }
    if ($if_modified_since && $if_modified_since != $last_modified) {
        return $last_check; // if-modified-since is there but doesn't match
    }

    // Nothing has changed since their last request - serve a 304 and exit
    header('HTTP/1.0 304 Not Modified');
    exit;
}
?>
