	device zxspectrum128

	; struct
data_x			equ 0
data_y			equ 1 + data_x
data_direction	equ 1 + data_y
data			equ 1 + data_direction

	; direction types ( also offset in getAttrAdr.jmpTable )
direction_up	equ 0
direction_left	equ 1 + direction_up
direction_down	equ 1 + direction_left
direction_right	equ 1 + direction_down

	; allocation data + code macro
	macro BOT_ALLOC arg0
arg0_data	ds data
arg0_init
		ld a, r
		and 0x1f
		ld [ arg0_data + data_x ], a
		ld a, r
		and 0xf
		ld [ arg0_data + data_y ], a
		ld a, r
		xor arg0_data & 0xff
		and 0x3
        ld [ arg0_data + data_direction ], a
		ret
arg0_doMove
		ld bc, [ arg0_data + data_x ]
		push bc
			call erase
			ld a, [ arg0_data + data_direction ]
		pop bc
		call bot_doMove
		ld [ arg0_data + data_direction ], a
		ld [ arg0_data + data_x ], bc
		jp draw
	endm

	; function calls
	macro BOT_INIT arg0
		call arg0_init
	endm
	macro BOT_MOVE arg0
		call arg0_doMove
	endm

	; instances names and count
    defarray bots a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18
bots_count equ 19


	org 0x6000
main
	ld sp, main
	
	ld hl, 0x5800, de, 0x5801, bc, 0x2ff, [ hl ], l
	ldir
	xor a: out [ 0xfe ], a

	call init
.l0
	call move

	ld bc, 0x1000
.l1
	dec bc
	ld a, b: or c
	jr nz, .l1
	
	jr .l0

; initialization
init
index defl 0
	dup bots_count
	BOT_INIT bots[ index ]
index defl index + 1
	edup
	ret

; move cycle
move
index defl 0
	dup bots_count
	BOT_MOVE bots[ index ]
index defl index + 1
	edup
	ret

	; data + code
index defl 0
	dup bots_count
	BOT_ALLOC bots[ index ]
index defl index + 1
	edup

	; some global functions
;	b - y
;	c - x
;	d - attr
erase
	call getAttrAdr
	ld [ hl ], c
	ret
draw
	call getAttrAdr
	dec c
	ld [ hl ], c
	ret

;	b - y
;	c - x
;<	hl - adr
getAttrAdr
	ld a, b
	add a, a, a, a, a, a
	ld l, a, h, 0, b, h
	add hl, hl, hl, hl, hl, bc
	ld bc, 0x5800
	add hl, bc
	ret

bot_doMove
	push af
		add a, a
		ld e, a
		ld d, 0
		ld hl, .jmpTable
		add hl, de
		ldi a, [ hl ]
		ld h, [ hl ], l, a
	pop af
	jp [ hl ]
.jmpTable
	dw .moveUp, .moveLeft, .moveDown, .moveRight

	; some macro
	macro MOVELEFT coordReg, otherDirection
		dec coordReg
		ret p
		ld a, otherDirection
		inc coordReg
		ret
	endm

	macro MOVERIGHT coordReg, maxCoord, otherDirection
		ld d, a, a, maxCoord
		cp coordReg
		jr nz, .keepDirection
		ld d, otherDirection
		dec coordReg
.keepDirection
		ld a, d
		inc coordReg
		ret
	endm

.moveUp
	MOVELEFT b, direction_down

.moveDown
	MOVERIGHT b, 23, direction_up

.moveLeft
	MOVELEFT c, direction_right

.moveRight
	MOVERIGHT c, 31, direction_left

	display "code len : ", /a, $ - main
	
	savesna "test.sna", main
	
