#include <windows.h>
#include "plugin.hpp"

PluginStartupInfo Info;
FARSTANDARDFUNCTIONS FSF;

void __stdcall Initialize(PluginStartupInfo *pInfo)
{
  Info = *pInfo;
  FSF = *Info.FSF;
}

int __stdcall Analyse(const char *lpFileName, const char *pBuffer, DWORD dwBufferSize)
{
  // we should have at least 9 sectors
  if(dwBufferSize < 9*256) return 0;
  if(pBuffer[0x8E7] != 0x10) return 0;

  if(Info.CmpName("*.trd", lpFileName, TRUE)) return 1;

  return 0;
}

void __cdecl WriteStr(HANDLE hFile, const char *format, ...)
{
  DWORD dwWritten;
  char szBuff[1024];

  memset (szBuff, 0, 1024);

  va_list argptr;

  va_start (argptr, format);
  wvsprintf (szBuff, format, argptr);
  va_end (argptr);

  WriteFile (hFile, szBuff, strlen (szBuff), &dwWritten, NULL);
}

#pragma pack(push, 1)
struct FileHdr
{
  char name[8];
  char type;
  WORD start;
  WORD size;
  BYTE noSecs;
  BYTE sec;
  BYTE trk;
};

struct DiskHdr
{
 BYTE firstFreeSec;
 BYTE firstFreeTrk;
 BYTE type;
 BYTE noFiles;
 WORD noFreeSecs;
 BYTE reserved[13];
 BYTE noDelFiles;
 char title[11];
};

#pragma pack(pop)

bool __stdcall Morph(HANDLE hFileToMorphFrom, HANDLE hFileToMorphTo)
{
  SetFilePointer(hFileToMorphFrom, 0, 0, FILE_BEGIN);
  BYTE data[9*256];

  DWORD read;
  ReadFile(hFileToMorphFrom, data, 9*256, &read, 0);

  FileHdr files[142];
  int noFiles = 0;
  int noDelFiles = 0;

  BYTE *p = data;

  for(int i = 0; i < 142; ++i)
  {
    // no more files...
    if(*p == 0) break;

    // is this file deleted?
    if(*p == 1) {
      ++noDelFiles;
    } else {
      CopyMemory((BYTE*) &files[i], p, sizeof(FileHdr));

      for(int j = 0; j < 8; ++j) {
        if(files[i].name[j] < ' ' || files[i].name[j] > 127) files[i].name[j] = ' ';
      }
      if(files[i].type < ' ' || files[i].type > 127) files[i].type = ' ';

      ++noFiles;
    }
    p += sizeof(FileHdr);

  }

  DiskHdr diskInfo;
  CopyMemory(&diskInfo, data+8*256+0xE1, sizeof(DiskHdr));

  char title[12];
  title[11] = 0;

  for(int i = 0; i < 11; ++i) {
    if(diskInfo.title[i] < ' ' || diskInfo.title[i] > 127)
      title[i] = ' ';
    else
      title[i] = diskInfo.title[i];
  }

  WriteStr(hFileToMorphTo, " Title     : %s\n", title);
  if(noFiles == diskInfo.noFiles)
    WriteStr(hFileToMorphTo, " Files     : %d\n", noFiles);
  else
    WriteStr(hFileToMorphTo, " Files     : %d(%d)\n", noFiles, diskInfo.noFiles);

  if(noDelFiles == diskInfo.noDelFiles)
    WriteStr(hFileToMorphTo, " Del. Files: %d\n", noDelFiles);
  else
    WriteStr(hFileToMorphTo, " Del. Files: %d(%d)\n", noDelFiles, diskInfo.noDelFiles);

  WriteStr(hFileToMorphTo,   " Free secs : %d\n\n", diskInfo.noFreeSecs);


  WriteStr(hFileToMorphTo, " Name      T  SSz  Start Len\n");
  WriteStr(hFileToMorphTo, " -----------------------------\n");

  char name[9];
  name[8] = 0;

  for(int i = 0; i < noFiles; ++i) {
    CopyMemory(name, files[i].name, 8);
    WriteStr(hFileToMorphTo, " %8s <%c> %3d  %05d %05d\n", name, files[i].type, files[i].noSecs, files[i].start, files[i].size);
  }

  return true;
}
