POnIIC:
	sbi	DDRD,led
	sbi	PORTD,led
	ser	temp
	out	DDRA,temp
	sbi	PORTA,VccIIC

	ldz	Tx_Str
	std	Z+x_Cmd,cmd
	stdi	Z+x_Nbt,0
	ldz	Do_End
	ijmp
	
ReadBlockIICB:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Str
	std	Z+x_Cmd,cmd
	ldi	loop,0x80
	std	Z+x_Nbt,loop
	ldz	Tx_Dat
	rcall	start
	mov	temp,addrL
	rcall	send
	mov	temp,addrH
	lsl     temp
	ori	temp,0xA0
	rcall	send
	rjmp    Rd_I

WriteBlockIICB:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Str
	std	Z+x_Cmd,cmd
	ldi	loop,0x80
	std	Z+x_Nbt,loop
	ldz	Tx_Dat
	rcall	start
	mov	temp,addrL
	rcall	send
	mov	temp,addrH
	lsl     temp
	ori	temp,0xA1
	rcall	send
	rjmp    Wr_I

ReadBlockIICW:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Str
	std	Z+x_Cmd,cmd
	ldi	loop,128
	std	Z+x_Nbt,loop
	ldz	Tx_Dat
	rcall	start
	ldi	temp,0xA0
	rcall	send
	mov	temp,addrH
	rcall	send
	mov	temp,addrL
	rcall	send
	rcall	start
	ldi	temp,0xA1
	rcall	send
Rd_I:	rcall	recv
	rcall	ack
	st	Z+,temp
	adiw	r26,1
	dec	loop
	brne	Rd_I
	rcall	recv
	rcall	nack
	rcall	stop
	ldz	Do_End
	ijmp

WriteBlockIICW:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldi	loop,128
	rcall	start
	ldi	temp,0xA0
	rcall	send
	mov	temp,addrH
	rcall	send
	mov	temp,addrL
	rcall	send
Wr_I:	ld	temp,Y+
	rcall	send
	dec	loop
	brne	Wr_I
	rcall	stop
	ldz	Tx_Str
	std	Z+x_Cmd,cmd
	stdi	Z+x_Nbt,0
	ldz	Do_End
	ijmp

recv:	push	loop
	ldi	loop,8
	rcall	highSDA
recvBit:
	rcall	highSCL
	lsl	temp
	andi	temp,0xFE
	sbic	PINA,SDA
	ori	temp,0x01
	rcall	lowSCL
	dec	loop
	brne	recvBit
	pop	loop
	ret

send:	push	loop
	ldi	loop,8
sendBit:
	sbrs	temp,7
	rcall	lowSDA
	sbrc	temp,7
	rcall	highSDA
	rcall	clkPulse
	sbrs	temp,7
	rcall	highSDA
	lsl	temp
	dec	loop
	brne	sendBit
	rcall	highSDA
	pop	loop
	rjmp	clkPulse

nack:	rcall	highSDA
	rjmp	clkPulse

ack:	rcall	lowSDA
	rjmp	clkPulse

start:
	rcall	lowSCL
	rcall	highSDA
	rcall	highSCL
	rcall	lowSDA
	rjmp	lowSCL

stop:
	rcall	lowSCL
	rcall	lowSDA
	rcall	highSCL
	rcall	highSDA
	rjmp	lowSCL

clkPulse:
	rcall	highSCL
	rjmp	lowSCL

highSDA:
	sbi	PORTA,SDA
	cbi	DDRA,SDA	; SDA - in
	rjmp	delay

lowSDA:
	cbi	PORTA,SDA
	sbi	DDRA,SDA	; SDA - out
	rjmp	delay

highSCL:
	sbi	PORTA,SCL
	cbi	DDRA,SCL
	rjmp	delay

lowSCL:
	cbi	PORTA,SCL
	sbi	DDRA,SCL

delay:
	nop
	nop
	nop
	nop
	ret
