;***** UART receive complete interrupt
UARTRX:	push	temp
	in	temp,SREG	;save status register
	push	temp
	in	temp,UDR	;get byte
	sei			;enable nested interrupts
	push	loop
	push	ZL
	push	ZH

	ldz	Rx_Str		;load RX data structure address

	cpi	temp,FEND
	brne	RX0
	std	Z+x_Pre,temp	;Rx_Pre = byte
	push	temp
	ldi	temp,CRC_Init
	std	Z+x_Crc,temp	;CRC init
	ldi	temp,x_Ptr
	std	Z+x_Ptr,temp	;pointer init
	pop	temp
	rjmp	RX12

RX0:	ldd	loop,Z+x_Ptr
	cpi	loop,x_Ptr	;if (Rx_Ptr == x_Ptr)
	brne	RX1
	rjmp	RX_RET		; Wait for FEND

RX1:	push	loop
	ldd	loop,Z+x_Pre	;load pre-byte
	std	Z+x_Pre,temp	;save new pre-byte
	mov	temp,loop
	pop	loop
	cpi	temp,FESC	;if (Rx_Pre == FESC)
	brne	RX3
	ldd	temp,Z+x_Pre
	cpi	temp,TFESC	; if (byte == TFESC)
	brne	RX2
	ldi	temp,FESC	;  byte = FESC
	rjmp	RX5
RX2:	cpi	temp,TFEND	;  else if (byte == TFEND)
	brne	RX_Err		;        byte = FEND
	ldi	temp,FEND	;	 else Rx_Err
	rjmp	RX5			

RX3:	ldd	temp,Z+x_Pre
	cpi	temp,FEND	;if (byte == FEND)
	breq	Rx_Err		; Rx_Err
RX4:	cpi	temp,FESC	;if (byte == FESC)
	breq	RX_RET		; skip

RX5:	cpi	loop,x_Add	;if (Rx_Ptr == x_Add)
	brne	RX7
	sbrc	temp,7		; if (byte.7 == 0)
	rjmp	RX6
	inc	loop		;  { inc R0
	std	Z+x_Ptr,loop	;    inc Rx_Ptr
	rjmp	RX11		;    save Tx_Cmd }
RX6:	clbr	temp,7
	tst	temp		; else if (!Addr) broadcast
	breq	RX12
	push	loop
	ldd	loop,Z+x_Add
	cp	temp,loop	;  else if (Addr == Rx_Add)
	pop	loop
	brne	RX10
	rjmp	RX12		;   match else new_frame

RX7:	cpi	loop,x_Cmd	;if (Rx_Ptr == x_Cmd)
	brne	RX8
	sbrc	temp,7		; if (byte.7 == 1)
	rjmp	Rx_Err		;  Rx_Err
	rjmp	RX11		;  else save Tx_Cmd	

RX8:	cpi	loop,x_Nbt	;if (Rx_Ptr == x_Nbt)
	brne	RX9
	cpi	temp,Frame	; if (Tx_Nbt < Frame)
	brlo	RX11		;  save Tx_Nbt
	ldi	temp,Frame	;  else { Tx_Nbt = Frame
	rjmp	RX11		;         save Tx_Nbt }

RX9:	push	temp
	ldd	temp,Z+x_Nbt
	subi	temp,-x_Nbt
	cp	temp,loop	;if (Rx_Ptr <= Rx_Nbt+x_Nbt)
	pop	temp
	brsh	RX11		; save Tx_Dat[] else

	ldd	loop,Z+x_Crc
	cp	temp,loop	;  if (byte != Rx_Crc) 
	brne	Rx_Err		;   Rx_Err
	ldd	CMD,Z+x_Cmd	;   else { CMD = Rx_Cmd
RX10:	ldi	temp,x_Ptr
	std	Z+x_Ptr,temp	;          Rx_Ptr = x_Ptr }
	rjmp	RX_RET

Rx_Err:	ldi	CMD,C_Err	;CMD = C_Err
	rjmp	RX10

RX11:	add	ZL,loop
	clr	loop
	adc	ZH,loop
	st	Z,temp		;save byte
	ldz	Rx_Str		;restore RX data structure address
RX12:	rcall	Do_Crc		;update CRC
	ldd	loop,Z+x_Ptr
	inc	loop
	std	Z+x_Ptr,loop	;inc Rx_Ptr

RX_RET:	pop	ZH
	pop	ZL
	pop	loop
	pop	temp
	out	SREG,temp	;restore status register
	pop	temp
	reti

;***** UART transmit complete interrupt
UARTTX:	sei			;enable nested interrupts
	push	temp
	in	temp,SREG	;save status register
	push	temp
	push	loop
	push	ZL
	push	ZH

	ldz	Tx_Str		;load TX data structure address

	ldd	loop, Z+x_Ptr
	ldd	temp,Z+x_Nbt
	subi	temp,-x_Dat
	cp	temp,loop	;if (Tx_Ptr > Tx_Nbt+x_Dat)
	brsh	TX0
	ldi	temp,x_Ptr
	std	Z+x_Ptr,temp
	rjmp	TX_RET		; TX complete

TX0:	brne	TX1		;if (Tx_Ptr == Tx_Nbt+x_Dat)
	ldd	temp,Z+x_Crc	; byte = Tx_Crc
	rjmp	TX4

TX1:	cpi	loop,x_Ptr	;if (Tx_Ptr == x_Ptr)
	brne	TX2
	ldi	temp,CRC_Init	; { CRC init
	std	Z+x_Crc,temp
	ldi	temp,FEND	;   byte = FEND
	std	Z+x_Pre,temp	;   save pre-byte }
	rjmp	TX4

TX2:	cpi	loop,x_Add	;if (Tx_Ptr == x_Add)
	brne	TX3
	ldd	temp,Z+x_Add	; { byte = Tx_Add
	tst	temp
	brne	TX4		;   if (Tx_Add == 0)
	inc	loop		;   inc loop
	std	Z+x_ptr,loop	;   inc Tx_Ptr }

TX3:	clr	temp
	add	ZL,loop
	adc	ZH,temp
	ld	temp,Z		;get byte
	ldz	Tx_Str		;restore TX data structure address
TX4:	push	temp		;save uncoded byte

	cpi	loop,x_Add	;if (Tx_Ptr == x_Add)
	brne	TX5
	ori	temp,0x80	; byte = byte | 0x80

TX5:	cpi	loop,x_Ptr	;if (Tx_Ptr == x_Ptr)
	breq	TX9		; skip stuffing

TX6:	cpi	temp,FEND	;if (byte == FEND)
	brne	TX7
	ldd	temp,Z+x_Pre
	cpi	temp,FESC	; if (Tx_Pre == FESC)
	brne	TX8
	ldi	temp,TFEND	;  byte = TFEND
	rjmp	TX9		;   else...

TX7:	cpi	temp,FESC	;else if (byte == FESC)
	brne	TX9
	ldd	temp,Z+x_Pre
	cpi	temp,FESC	; if (Tx_Pre == FESC)
	brne	TX8
	ldi	temp,TFESC	;  byte = TFESC
	rjmp	TX9

TX8:	ldi	temp,FESC	;   else { byte = FESC
	out	UDR,temp	;          TX byte
	std	Z+x_Pre,temp	;          save pre-byte }
	pop	temp		;stack balance
	rjmp	TX_RET

TX9:	out	UDR,temp	;TX byte
	std	Z+x_Pre,temp	;save pre-byte
	pop	temp		;get uncoded byte
	rcall	Do_CRC		;update CRC
	ldd	loop,Z+x_Ptr
	inc	loop
	std	Z+x_Ptr,loop	;inc Tx_Ptr

TX_RET:	pop	ZH
	pop	ZL
	pop	loop
	pop	temp
	out	SREG,temp	;restore status register
	pop	temp
	reti

;Update CRC:
;Input: temp - data byte
;Z - pointer to Rx_Str or Tx_Str
;Out: [Z+x_Crc] - new CRC value

Do_CRC:	push	YL
	push	YH
	ldi	loop,8        	;Set to shift eight bits
	ldd	YH,Z+x_Crc
	
CRCL:	mov	YL,temp
	eor	YL,YH    	;Calculate DQIN xor CRCT0
	ror	YL          	;Move it to the carry
	brcc	ZERO        	;Skip if DQIN xor CRCT0 = 0
	ldi	YL,0x18
	eor	YH,YL    	;Update the CRC value
ZERO:	ror	YH          	;Position the new CRC
	lsr	temp           	;Position next bit in LSB
	dec	loop
	brne	CRCL		;Repeat for eight bits
	std	Z+x_Crc,YH
	pop	YH
	pop	YL
	ret
