unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Spin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open: TMenuItem;
    Save: TMenuItem;
    SaveAs: TMenuItem;
    Device1: TMenuItem;
    Options: TMenuItem;
    MReadDevice: TMenuItem;
    MWriteDevice: TMenuItem;
    MDeviceType: TMenuItem;
    Mwinbond: TMenuItem;
    Miic8: TMenuItem;
    Miic16: TMenuItem;
    MPort: TMenuItem;
    MInfo: TMenuItem;
    MAbout: TMenuItem;
    StatusBar1: TStatusBar;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Bevel1: TBevel;
    BufAddrPr: TEdit;
    FlashAddrPr: TEdit;
    BlockSizePr: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MVerifyDevice: TMenuItem;
    MEraseDevice: TMenuItem;
    Mamd: TMenuItem;
    Mspeed: TMenuItem;
    N19200: TMenuItem;
    N57600: TMenuItem;
    N115200: TMenuItem;
    Mgoto: TMenuItem;
    MLockDevice: TMenuItem;
    MUnlockDevice: TMenuItem;
    Meeprom: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SaveClick(Sender: TObject);
    procedure OpenClick(Sender: TObject);
    procedure SaveAsClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BlockSizePrKeyPress(Sender: TObject; var Key: Char);
    procedure FlashAddrPrKeyPress(Sender: TObject; var Key: Char);
    procedure BufAddrPrKeyPress(Sender: TObject; var Key: Char);
    procedure MgotoClick(Sender: TObject);
    procedure MainMenuClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  WS_EX_LAYERED=$80000;
  LWA_ALPHA=2;

  CRC_Init=$DE;
  FEND=$C0;
  FESC=$DB;
  TFEND=$DC;
  TFESC=$DD;

  C_Nop         = 0;
  C_Err         = 1;
  C_Echo        = 2;
  C_Info        = 3;
  C_Setup       = 4;
  C_POff        = 5;
  C_POn         = 6;
  C_ReadBlock   = 7;
  C_WriteBlock  = 8;
  C_Erase       = 9;
  C_Lock        = 10;
  C_Unlock      = 11;

var
  Form1:TForm1;
  dcb,dcbc:TDCB;
  ComTo,ComToc:TCOMMTIMEOUTS;
  TxBuff,RxBuff:array[0..255]of byte;
  devid,half,Adr,Cmd,N:byte;
  FileBuff:array[0..$80000]of byte;
  CursorX,CursorY,CurrAddr,BuffAddr,FlashAddr,BlockSize,hCom:dword;
  breakOperation:boolean;
  Port,iniFile,firmware:string;
  speed:dword;
  devices:array[0..100]of TMenuItem;

implementation
{$R *.DFM}

// ===== wake protocol =====
function FlushCOM:boolean;
begin
  result:=FlushFileBuffers(hCom);
end;

 function PurgeCOM:boolean;
begin
  result:=PurgeComm(hCom, PURGE_TXABORT or PURGE_RXABORT or PURGE_TXCLEAR or PURGE_RXCLEAR);
end;

function SetModLns(F:dword):boolean;
begin
  result:=EscapeCommFunction(hCom, F);
end;

function GetModLns(var lpD:dword):boolean;
begin
 result:=GetCommModemStatus(hCom, lpD);
end;

function GetMaskCOM(var lpEvtMask:dword):boolean;
begin
  result:=GetCommMask(hCom, lpEvtMask);
end;

function SetMaskCOM(EvtMask:dword):boolean;
begin
 result:=SetCommMask(hCom, EvtMask);
end;

function WaitEventCOM(var lpEvtMask:dword):boolean;
begin
 result:=WaitCommEvent(hCom, lpEvtMask, nil);
end;

function AccessCOM(p:PChar):boolean;
var hTemp:dword;
begin
  hTemp:=CreateFile(p,GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  if hTemp<>INVALID_HANDLE_VALUE then begin
    CloseHandle(hTemp);
    result:=true;
    exit;
  end;
  result:=false;
end;

function OpenCOM(p:PChar;baud:dword):boolean;
begin
  hCom:=CreateFile(p,GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  if hCom = INVALID_HANDLE_VALUE then begin
    result:=false;
    exit;
  end;
  if not GetCommState(hCom, dcb) then begin
    result:=false;
    exit;
  end;
  if not GetCommTimeouts(hCom, ComTo) then begin
    result:=false;
    exit;
  end;
  dcbc:=dcb; ComToc:=ComTo;
  dcb.BaudRate:=baud;
  dcb.ByteSize:=8;
  dcb.Parity:=NOPARITY;
  dcb.StopBits:=ONESTOPBIT;
//  dcb.fBinary:=1;
//  dcb.fDtrControl:=DTR_CONTROL_DISABLE;
//  dcb.fRtsControl:=RTS_CONTROL_ENABLE;
  if not SetCommState(hCom, dcb) then begin
    result:=false;
    exit;
  end;
  if not SetupComm(hCom, 512, 512) then begin
    result:=false;
    exit;
  end;
  ComTo.ReadIntervalTimeout:=MAXDWORD;
  ComTo.ReadTotalTimeoutMultiplier:=MAXDWORD;
  ComTo.ReadTotalTimeoutConstant:=1000;
  ComTo.WriteTotalTimeoutMultiplier:=0;
  ComTo.WriteTotalTimeoutConstant:=1000;
  if not SetCommTimeouts(hCom, ComTo)then begin
    result:=false;
    exit;
  end;
  if not PurgeCOM then begin
    result:=false;
    exit;
  end;
  result:=true;
end;

function CloseCOM:boolean;
begin
  if not SetCommState(hCom, dcbc) then begin
    result:=false;
    exit;
  end;
  if not SetCommTimeouts(hCom, ComToc) then begin
    result:=false;
    exit;
  end;
  if not CloseHandle(hCom) then begin
    result:=false;
    exit;
  end;
  result:=true;
end;

procedure DowCRC(b:byte;var crc:byte);
var i:dword;
begin
  for i:=0 to 7 do begin
    if ((b xor crc) and 1)<>0 then crc:=((crc xor $18) shr 1) or $80
                              else crc:=(crc shr 1) and $7F;
    b:=b shr 1;
  end;
end;

function RxByteCOM(var b:byte):boolean;
var r:dword;
    x:boolean;
begin
  x:=ReadFile(hCom,b,1,r,nil);
  result:=x and (r=1);
end;

function RxFrame(Tout:dword; var ADD,CMD,N:byte; var Data:array of byte):boolean;
var i:integer;
    b,crc:byte;
begin
  crc:=CRC_Init;
  b:=0;
  ComTo.ReadTotalTimeoutConstant:=Tout;
  if not SetCommTimeouts(hCom, ComTo) then begin
    RxFrame:=false;
    exit;
  end;
  for i:=0 to 511 do begin
    if not RxByteCOM(b) then break;
    if b=FEND then break;
  end;
  if b<>FEND then begin
    RxFrame:=false;
    exit;
  end;
  DowCRC(b, crc);
  ADD:=0; N:=0;
  i:=-3;
  repeat
    if not RxByteCOM(b)then break;
    if (b=FESC) then
      if not RxByteCOM(b) then break
      else begin
        if b=TFEND then b:=FEND
        else
          if b=TFESC then b:=FESC
          else break;
      end;
    DowCRC(b, crc);
    if i=-3 then
      if b and $80=0 then begin
        CMD:=b;
        inc(i);
      end
      else ADD:=b and $7F
    else
      if i=-2 then
        if b and $80<>0 then break
        else CMD:=b
      else
        if i=-1 then N:=b
        else
          if i<>N then Data[i]:=b;
    inc(i);
  until i>N;
  result:=(i=N+1) and (crc=0);
end;

function TxFrame(ADDR,CMD,N:byte;Data:array of byte):boolean;
var Buff:array[0..518]of byte;
    i:integer;
    r,j:dword;
    d,crc:byte;
    x:boolean;
begin
  crc:=CRC_Init;
  j:=0;
  i:=-4;
  repeat;
    if (i=-3) and (ADDR=0) then inc(i);
    if i=-4 then d:=FEND
    else
      if i=-3 then d:=ADDR
      else
        if i=-2 then d:=CMD
        else
          if i=-1 then d:=N
          else
            if i=N then d:=crc
            else
              d:=Data[i];
    DowCRC(d, crc);
    if i=-3 then d:=d or $80;
    if (i>-4) and ((d=FEND) or (d=FESC)) then begin
      Buff[j]:=FESC;
      inc(j);
      if d=FEND then d:=TFEND
                else d:=TFESC;
    end;
    Buff[j]:=d;
    inc(j);
    inc(i);
  until i>N;
  x:=WriteFile(hCom,Buff,j,r,nil);
  result:=x and (r=j);
end;

function InitCOM(PortN:string;speedN:dword; var ErrorMsg:string):boolean;
var i:integer;
begin
  case speedN of
    19200: TxBuff[0]:=71;
    57600: TxBuff[0]:=23;
    115200: TxBuff[0]:=11;
  else
    InitCOM:=false;
    exit;
  end;
  CloseCOM;
  if not AccessCOM(PChar(PortN)) then begin
    ErrorMsg:='error opening port!';
    InitCom:=false;
    exit;
  end;
  OpenCOM(PChar(PortN),19200);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(200);
  CloseCOM;
  OpenCOM(PChar(PortN),57600);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(200);
  CloseCOM;
  OpenCOM(PChar(PortN),115200);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(200);
  CloseCOM;
  OpenCOM(PChar(PortN),speedN);
  TxFrame(0,C_Info,0,TxBuff);
  if not RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err) then begin
    ErrorMsg:='device not found!';
    InitCOM:=false;
    exit;
  end;
  firmware:='';
  for i:=0 to N-2 do firmware:=firmware+chr(RxBuff[i]);
  Port:=PortN;
  speed:=speedN;
  ErrorMsg:='no error';
  result:=true;
end;

procedure AddCOMPorts;
var i:integer;
    NewItem:TMenuItem;
    NotifyEvent:TNotifyEvent;
begin
  for i:=1 to 32 do begin
    NewItem:=TMenuItem.Create(Form1.MainMenu1);
    NewItem.Caption:='COM'+intToStr(i);
    NotifyEvent:=Form1.MainMenuClick;
    NewItem.OnClick:=NotifyEvent;
    if AccessCOM(PChar('COM'+intToStr(i))) then Form1.MPort.Add(NewItem);
  end;
end;

// ===== flash =====
function ReadBlock(addr:dword):boolean;
begin
  TxBuff[0]:=devid;
  TxBuff[1]:=lo(addr);
  TxBuff[2]:=hi(addr);
  TxBuff[3]:=(addr and $FF0000)shr $10;
  TxFrame(0,C_ReadBlock,4,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function WriteBlock(addr:dword):boolean;
begin
  TxBuff[0]:=devid;
  TxBuff[1]:=lo(addr);
  TxBuff[2]:=hi(addr);
  TxBuff[3]:=(addr and $FF0000)shr $10;
  TxFrame(0,C_WriteBlock,128+4,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function PowerOn:boolean;
begin
  TxBuff[0]:=devid;
  TxFrame(0,C_POn,1,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function PowerOff:boolean;
begin
  TxFrame(0,C_POff,0,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function GetDevName(DevIdN:byte):string;
begin
  case devIdN of
    0: result:='winbond';
    1: result:='amd';
    2: result:='iic word';
    3: result:='eeprom';
    4: result:='iic byte';
  end;
end;

function GetDevID(DevName:string):byte;
begin
  result:=255;
  if DevName='winbond' then result:=0;
  if DevName='amd' then result:=1;
  if DevName='iic word' then result:=2;
  if DevName='iic byte' then result:=4;
  if DevName='eeprom' then result:=3;
end;

function CheckBlock(addr:dword):boolean;
var k:dword;
begin
  for k:=0 to 127 do
    if RxBuff[k]<>FileBuff[addr+k] then begin
      CheckBlock:=false;
      exit;
    end;
  result:=true;
end;

procedure ReadDevice;
var err,i,j,k:dword;
begin
  if not BreakOperation then exit;
  BreakOperation:=false;
  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    Application.ProcessMessages;
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='reading: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText+' trying: '+intToStr(err);
    if not ReadBlock(j) then begin
      if err=10 then begin
        PowerOff;
        MessageDlg('read error!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      inc(err);
      sleep(200);
      continue;
    end;
    for k:=0 to 127 do FileBuff[i+k]:=RxBuff[k];
    inc(i,128);
    inc(j,128);
    err:=0;
    Application.ProcessMessages;
  until i>=BuffAddr+BlockSize;
  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('read complete!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  FlashAddr:=j;
  Form1.FlashAddrPr.Text:=intToHex(FlashAddr,5);
  Form1.Paint;
end;

procedure WriteDevice;
var err,i,j,k:dword;
begin
  if not BreakOperation then exit;
  BreakOperation:=false;
  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    Application.ProcessMessages;
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='writing: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText + ' trying: '+intToStr(err);
    for k:=0 to 127 do TxBuff[k+4]:=FileBuff[i+k];
    WriteBlock(j);
    ReadBlock(j);
    if not CheckBlock(i) then begin
      PowerOff;
      if err=10 then begin
        MessageDlg('write error!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      PowerOn;
      inc(err);
      sleep(200);
      continue;
    end;
    err:=0;
    inc(i,128);
    inc(j,128);
  until i>=BuffAddr+BlockSize;
  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('write complete!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  FlashAddr:=j;
  Form1.FlashAddrPr.Text:=intToHex(FlashAddr,5);
  Form1.Paint;
end;

procedure VerifyDevice;
var err,i,j:dword;
begin
  if not BreakOperation then exit;
  BreakOperation:=false;
  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    Application.ProcessMessages;
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='verifing: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText + ' trying: '+intToStr(err);
    ReadBlock(j);
    if not CheckBlock(i) then begin
      if err=10 then begin
        PowerOff;
        MessageDlg('difference found!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      inc(err);
      sleep(200);
      continue;
    end;
    err:=0;
    inc(i,128);
    inc(j,128);
    Application.ProcessMessages;
  until i>=BuffAddr+BlockSize;
  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('inentical!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  Form1.Paint;
end;

procedure EraseDevice;
begin
  if not BreakOperation then exit;
  if MessageDlg('realy?',mtConfirmation,[mbYes,mbNo],0)<>mrYes then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=devid;
  TxFrame(0,C_Erase,1,TxBuff);
  if not ((RxFrame(10000,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

procedure LockDevice;
begin
  if not BreakOperation then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=devid;
  TxFrame(0,C_Lock,1,TxBuff);
  if not ((RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

procedure UnlockDevice;
begin
  if not BreakOperation then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=devid;
  TxFrame(0,C_UnLock,1,TxBuff);
  if not ((RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

function GetIniKey(key,def:string):string;
var buffer:array[0..127]of byte;
    temp:string;
    i:integer;
begin
  iniFile:=ChangeFileExt(Application.ExeName,'.ini');
  GetPrivateProfileStringA('options',PChar(key),PChar(def),addr(buffer),sizeof(buffer),PChar(iniFile));
  temp:='';
  for i:=0 to 127 do
    if buffer[i]=0 then break
                   else temp:=temp+chr(buffer[i]);
  result:=temp;
end;

// ===== main =====
procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var temp:string;
begin
  if not BreakOperation then begin
    BreakOperation:=true;
    exit;
  end;
  WritePrivateProfileString('options','port',PChar(Port),PChar(iniFile));
  temp:=intToStr(speed);
  WritePrivateProfileString('options','speed',PChar(temp),PChar(iniFile));
  temp:=GetDevName(devid);
  WritePrivateProfileString('options','ROMtype',PChar(temp),PChar(iniFile));
  CloseCOM;
end;

procedure TForm1.FormCreate(Sender: TObject);
var ErrorMsg: string;
begin
  AddCOMPorts;
  Port:='COM1';
  speed:=19200;
  devid:=GetDevId(GetIniKey('ROMtype','winbond'));
  if not InitCOM(GetIniKey('port','COM1'),StrToIntDef(GetIniKey('speed','19200'),19200), ErrorMsg) then
    MessageDlg(ErrorMsg,mtError,[mbOK],0);
  Form1.Paint;
  FillChar(FileBuff,sizeof(FileBuff),0);
  CurrAddr:=0;
  CursorX:=0;
  CursorY:=0;
  half:=$F0;
  BuffAddr:=0;
  FlashAddr:=0;
  BlockSize:=$80000;
  Form1.SaveDialog1.InitialDir:=GetCurrentDir;
  Form1.OpenDialog1.InitialDir:=GetCurrentDir;
  BreakOperation:=true;
  Form1.StatusBar1.SimpleText:='';
end;

procedure TForm1.FormPaint(Sender: TObject);
var i,j:word;
begin
  Form1.StatusBar1.SimpleText:=Port+' '+IntToStr(speed)+' '+GetDevName(devid);
  Form1.BufAddrPr.Text:=IntToHex(BuffAddr,5);
  Form1.FlashAddrPr.Text:=IntToHex(FlashAddr,5);
  Form1.BlockSizePr.Text:=IntToHex(BlockSize,5);
  Form1.ActiveControl:=nil;
  Form1.Canvas.Brush.Color:=clBtnFace;
  for i:=0 to 15 do begin
    Form1.Canvas.TextOut(2,1+i*14,IntToHex(CurrAddr+i*16,5)+' ');
    for j:=0 to 15 do begin
      if (i=CursorY) and (j=CursorX) then Form1.Canvas.Brush.Color:=clGray;
      Form1.Canvas.TextOut(42+j*16,1+i*14,IntToHex(FileBuff[CurrAddr+i*16+j],2));
      Form1.Canvas.Brush.Color:=clBtnFace;
      if (FileBuff[CurrAddr+i*16+j]>=$20) and (FileBuff[CurrAddr+i*16+j]<=$7F) then Form1.Canvas.TextOut(304+j*8,1+i*14,chr(FileBuff[CurrAddr+i*16+j]))
                                                                               else Form1.Canvas.TextOut(304+j*8,1+i*14,'.');
    end;
  end;
end;

procedure TForm1.MainMenuClick(Sender: TObject);
var Item:TMenuItem;
    temp,ErrorMsg:string;
begin
  Item:=Sender as TMenuItem;

  if Item.Caption = 'read' then
    ReadDevice;
  if Item.Caption = 'write' then
    WriteDevice;
  if Item.Caption = 'verify' then
    VerifyDevice;
  if Item.Caption = 'erase' then
    EraseDevice;
  if Item.Caption = 'lock' then
    LockDevice;
  if Item.Caption = 'unlock' then
    UnLockDevice;
  if Item.Caption = 'about' then begin
    temp:='Flasher v0.14b'+chr($0d)+chr($0a)+'firmware: '+firmware+chr($0d)+chr($0a)+'(C) 2008 skyther';
    MessageDlg(temp,mtInformation,[mbOK],0);
  end;

  if Item.Caption = 'winbond' then
    devid:=0;
  if Item.Caption = 'amd' then
    devid:=1;
  if Item.Caption = 'iic word' then
    devid:=2;
  if Item.Caption = 'iic byte' then
    devid:=4;
  if Item.Caption = 'eeprom' then
    devid:=3;

  if Item.Caption = '19200' then
    if not InitCOM(Port,19200,ErrorMsg)then
      if not InitCOM(Port,speed,ErrorMsg) then
        MessageDlg(ErrorMsg,mtError,[mbOK],0);
  if Item.Caption = '57600' then
    if not InitCOM(Port,57600,ErrorMsg)then
      if not InitCOM(Port,speed,ErrorMsg) then
        MessageDlg(ErrorMsg,mtError,[mbOK],0);
  if Item.Caption = '115200' then
    if not InitCOM(Port,115200,ErrorMsg)then
      if not InitCOM(Port,speed,ErrorMsg) then
        MessageDlg(ErrorMsg,mtError,[mbOK],0);
  if copy(Item.Caption,1,3) = 'COM' then
    if not InitCOM(PChar(Item.Caption),speed,ErrorMsg)then
      if not InitCOM(Port,speed,ErrorMsg) then
        MessageDlg(ErrorMsg,mtError,[mbOK],0);

  Form1.Paint;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var ch:char;
begin
  if Key=VK_ESCAPE then breakOperation:=true;

  if HiWord(GetKeyState(VK_CONTROL))=0 then begin
    if Key=VK_UP then
      if CursorY=0 then dec(CurrAddr,16*byte(CurrAddr>0))
                   else dec(CursorY);
    if Key=VK_DOWN then
      if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$7FF00))
                    else inc(CursorY);
    if Key=VK_LEFT then dec(CursorX,byte(CursorX>0));
    if Key=VK_RIGHT then inc(CursorX,byte(CursorX<15));
    if Key=VK_HOME then CursorX:=0;
    if Key=VK_END then CursorX:=15;

    if Key=VK_PRIOR then
      if CursorY>0 then CursorY:=0
                   else dec(CurrAddr,$100*byte(CurrAddr>=$100));
    if Key=VK_NEXT then
      if CursorY<15 then CursorY:=15
                    else inc(CurrAddr,$100*byte(CurrAddr<=$7FE00));
  end
  else begin
    if Key=VK_UP then dec(CurrAddr,16*byte(CurrAddr>0));
    if Key=VK_DOWN then inc(CurrAddr,16*byte(CurrAddr<$7FF00));
    if Key=VK_HOME then begin
      CurrAddr:=0;
      CursorX:=0;
      CursorY:=0;
    end;
    if Key=VK_END then begin
      CurrAddr:=$7FF00;
      CursorX:=15;
      CursorY:=15;
    end;
    if Key=VK_PRIOR then dec(CurrAddr,$4000*byte(CurrAddr>=$4000));
    if Key=VK_NEXT then inc(CurrAddr,$4000*byte(CurrAddr<=$7BFF0));
  end;
  ch:=upCase(chr(Key));
  case ch of
    '0'..'9': begin
      FileBuff[CurrAddr+CursorX+CursorY*$10]:=(FileBuff[CurrAddr+CursorX+CursorY*$10] and not half) or (ord(ch)-ord('0')+(ord(ch)-ord('0'))*$10)and half;
      half:=not half;
      if half=$F0 then inc(CursorX);
      if CursorX=16 then begin
        CursorX:=0;
       if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$3FF00))
                     else inc(CursorY);
      end;
    end;
    'A'..'F': begin
      FileBuff[CurrAddr+CursorX+CursorY*$10]:=(FileBuff[CurrAddr+CursorX+CursorY*$10] and not half) or (ord(ch)-ord('A')+$0A+(ord(ch)-ord('A')+$0A)*$10)and half;
      half:=not half;
      if half=$F0 then inc(CursorX);
      if CursorX=16 then begin
        CursorX:=0;
       if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$3FF00))
                     else inc(CursorY);
      end;
    end
    else
    half:=$F0;
  end;
  Form1.Paint;
end;

procedure TForm1.OpenClick(Sender: TObject);
var FileSize,hFile:dword;
begin
  if not Form1.OpenDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.OpenDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  ReadFile(hFile,FileBuff,$80000,FileSize,nil);
  CloseHandle(hFile);
  Form1.BufAddrPr.Text:='00000';
  BuffAddr:=0;
  Form1.BlockSizePr.Text:=intToHex(FileSize,5);
  BlockSize:=FileSize;
  Form1.Caption:='flaser - '+ExtractFileName(Form1.OpenDialog1.FileName);
  Application.Title:='flaser - '+ExtractFileName(Form1.OpenDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.SaveClick(Sender: TObject);
var i,hFile:dword;
begin
  if Form1.SaveDialog1.FileName='' then
    if not Form1.SaveDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.SaveDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,0,0);
  WriteFile(hFile,FileBuff,BlockSize,i,nil);
  CloseHandle(hFile);
  Form1.Caption:='flaser - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Application.Title:='flaser - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.SaveAsClick(Sender: TObject);
var i,hFile:dword;
begin
  if not Form1.SaveDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.SaveDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,0,0);
  WriteFile(hFile,FileBuff,BlockSize,i,nil);
  CloseHandle(hFile);
  Form1.Caption:='flaser - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Application.Title:='flaser - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.BufAddrPrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.BufAddrPr.Text) do begin
      ch:=upcase(Form1.BufAddrPr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.BufAddrPr.Text:=intToHex(j,5);
    BuffAddr:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.FlashAddrPrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.FlashAddrPr.Text) do begin
      ch:=upcase(Form1.FlashAddrPr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.FlashAddrPr.Text:=intToHex(j,5);
    FlashAddr:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.BlockSizePrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.BlockSizePr.Text) do begin
      ch:=upcase(Form1.BlockSizePr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.BlockSizePr.Text:=intToHex(j,5);
    BlockSize:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.MgotoClick(Sender: TObject);
var temp:string;
    i:dword;
begin
  temp:=InputBox('goto','','0');
  CurrAddr:=0;
  for i:=1 to length(temp) do
    case UpCase(temp[i]) of
      '0'..'9': CurrAddr:=CurrAddr*16+ord(temp[i])-ord('0');
      'A'..'F': CurrAddr:=CurrAddr*16+ord(UpCase(temp[i]))-ord('A')+10;
    end;
  CursorX:=CurrAddr and $0F;
  CurrAddr:=CurrAddr and $FFFFF0;
  CursorY:=CurrAddr;
  if CurrAddr>$3FF00 then CurrAddr:=$3FF00;
  CursorY:=(CursorY-CurrAddr) div 16 and $0F;
  Form1.Paint;
end;

end.
