library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity speccy2007_vid is
    port(
        CLK     : in std_logic;
        
        CLK_CPU : out std_logic := '1';
        WAIT_CPU: out std_logic := '1';
        INT     : out std_logic := '1';

        RD      : in std_logic;
        WR      : in std_logic;
        IOREQ   : in std_logic;
        MREQ    : in std_logic;
        M1      : in std_logic;

        VAGEN   : out std_logic := '1';
        
        VA      : inout std_logic_vector(13 downto 0) := "ZZZZZZZZZZZZZZ";
        VD      : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ";

        VRD     : out std_logic := '1';
        VWR     : out std_logic := '1';
        VRAM    : out std_logic := '1';

        --A0        : in std_logic;
        --A7        : in std_logic;
        
        A14     : in std_logic;
        A15     : in std_logic;
        D       : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ";
        
        RAM     : out std_logic := '1';
        ROM     : out std_logic := '1';
        
        SYNC    : out std_logic := '1';     
        R       : out std_logic := '0';
        G       : out std_logic := '0';
        B       : out std_logic := '0';
        
        BR      : out std_logic := '0';     
        BG      : out std_logic := '0';     
        BB      : out std_logic := '0';     
        
        SOUND   : out std_logic := '1';
        
        AVR_NOINT: in std_logic;
        AVR_WAIT: in std_logic;
        AVR_INT : out std_logic := '1';

        AVR_TRDOS_OUT: out std_logic  := '0'
        --TAPE_OUT  : out std_logic := '1'
        );
end speccy2007_vid;

architecture rtl of speccy2007_vid is

    signal Tick     : std_logic := '0';
    signal Invert   : unsigned(3 downto 0) := "0000";

    signal ChrC_Cnt : unsigned(2 downto 0) := "000";    -- Character column counter
    signal Hor_Cnt  : unsigned(5 downto 0) := "000000"; -- Horizontal counter
    signal ChrR_Cnt : unsigned(2 downto 0) := "000";    -- Character row counter
    signal Ver_Cnt  : unsigned(5 downto 0) := "000000"; -- Vertical counter

    signal Attr     : std_logic_vector(7 downto 0);
    signal Shift    : std_logic_vector(7 downto 0);
    
    signal Paper_r  : std_logic;
    signal Blank_r  : std_logic;
    signal Attr_r   : std_logic_vector(7 downto 0);
    signal Shift_r  : std_logic_vector(7 downto 0);
    
    signal BorderAttr: std_logic_vector(2 downto 0) := "000";
        
    signal VideoRead : std_logic := '0';
    signal VideoRead1: std_logic := '0';
    signal VideoRead2: std_logic := '0';
    
    signal VRAM_ACC  : std_logic := '0';
    signal AVR_PORT  : std_logic := '0';
    signal wait_sync : std_logic := '1';

    signal paper     : std_logic;
    signal hsync     : std_logic;
    signal vsync1    : std_logic;
    signal vsync2    : std_logic;

    signal wait1     : std_logic;
    signal wait2     : std_logic;


    signal RD2       : std_logic;
    signal TRDOS_FLG : std_logic := '0';
    signal TRDOS_CHG : std_logic := '0';
    signal TRDOS_IN  : std_logic := '0';
    signal TRDOS_OUT : std_logic := '0';

begin
    ROM <= '0' when MREQ = '0' and A15 = '0' and A14 = '0' and TRDOS_CHG = '0' else '1';
    RAM <= '0' when MREQ = '0' and A15 = '1' else '1';
    VRAM_ACC <= '0' when ( MREQ = '0' and A15 = '0' and A14 = '1' ) else '1';
    
    --CVRD <= '0' when ( VRAM_ACC = '0' and RD = '0' and VideoRead = '1' ) else '1';
    --CVWR <= '0' when ( VRAM_ACC = '0' and WR = '0' and VideoRead = '1' ) else '1';

    VRAM <= '0' when ( VRAM_ACC = '0' and VideoRead = '1' ) or ( VideoRead1 = '0' and VideoRead2 = '0' ) else '1';  
    VRD <= '0' when ( VRAM_ACC = '0' and RD = '0' and VideoRead = '1' ) or ( VideoRead1 = '0' and VideoRead2 = '0' ) else '1';  
    VWR <= '0' when VRAM_ACC = '0' and WR = '0' and VideoRead = '1' else '1';

--    VAGEN <= '0' when VideoRead1 = '1' and ( VRAM_ACC = '0' or IOREQ = '0' ) else '1';      
    --VAGEN <= '0' when VideoRead1 = '1' and ( A15 = '0' and A14 = '1' ) else '1';
--    VAGEN <= '0' when VideoRead1 = '1' else '1';
    VAGEN <= '0' when VideoRead1 = '1' and ( VRAM_ACC = '0' or IOREQ = '0' or (M1 = '0' and MREQ = '0' and RD = '0')) else '1'; 

    wait1 <= '0' when ( wait_sync = '0' and VRAM_ACC = '0' and WR = '1') or ( VideoRead = '0' and IOREQ = '0' ) else '1';
    wait2 <= '0' when ( AVR_PORT = '0' and AVR_WAIT = '0' ) or ( AVR_PORT = '1' and AVR_WAIT = '1' ) else '1';
    paper <= '0' when Hor_Cnt(5) = '0' and Ver_Cnt(5) = '0' and ( Ver_Cnt(4) = '0' or Ver_Cnt(3) = '0' ) else '1';      

    hsync <= '0' when Hor_Cnt(5 downto 2) = "1010" else '1';
    vsync1 <= '0' when Hor_Cnt(5 downto 1) = "00110" or Hor_Cnt(5 downto 1) = "10100" else '1';
    vsync2 <= '1' when Hor_Cnt(5 downto 2) = "0010" or Hor_Cnt(5 downto 2) = "1001" else '0';

--    TRDOS_IN <= '1' when M1 = '0' and MREQ = '0' and RD = '0' and A14 = '0' and A15 = '0' and TRDOS_FLG = '0' and VA(13 downto 8) = "111101" else '0';
    TRDOS_IN <= '1' when M1 = '0' and RD = '0' and MREQ = '0' and A14 = '0' and A15 = '0' and TRDOS_FLG = '0' and VA(13 downto 8) = "111101" else '0';
    TRDOS_OUT <= '1' when M1 = '0' and RD = '0' and MREQ = '0' and (A14 ='1' or A15 = '1') and TRDOS_FLG = '1' else '0';

    D <= VD when VRAM_ACC = '0' and RD2 = '0' and VideoRead = '1' else "ZZZZZZZZ";

    VD <= D when VRAM_ACC = '0' and WR = '0' and VideoRead = '1' else "ZZZZZZZZ";
--    VA <= V_ADDR when VideoRead = '0' else "ZZZZZZZZZZZZZZ";
--    VA <= "ZZZZZZZZZZZZZZ";

    AVR_INT <= '0' when AVR_PORT = '0' or TRDOS_CHG = '1' else '1';
    AVR_TRDOS_OUT <= TRDOS_FLG;

    -- generate Z80 CLOCK 3.5 MHz
    process( CLK )
    begin
        -- rising edge of CLK
        if CLK'event and CLK = '1' then
            if Tick = '1' then
                if ChrC_Cnt(0) = '1' then 
                    if wait1 = '1' and wait2 = '1' and TRDOS_CHG = '0' then
                        CLK_CPU <= '0';
                    end if;
                else
                    CLK_CPU <= '1';
                end if;
            end if;
            
            RD2 <= RD;
            
        end if;     
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
        
            if Tick = '1' then
            
                if ChrC_Cnt = 7 then
                
                    if Hor_Cnt = 55 then
                        Hor_Cnt <= (others => '0');
                    else
                        Hor_Cnt <= Hor_Cnt + 1;
                    end if;
                    
                    if Hor_Cnt = 39 then                    
                        if ChrR_Cnt = 7 then
                            if Ver_Cnt = 38 then
                                Ver_Cnt <= (others => '0');
                                Invert <= Invert + 1;
                            else
                                Ver_Cnt <= Ver_Cnt + 1;
                            end if;                         
                        end if;                     
                        ChrR_Cnt <= ChrR_Cnt + 1;
                    end if;
                end if;
                
                if ChrC_Cnt = 7 then
                    
                    if not ( Ver_Cnt = 31 ) then
                        SYNC <= hsync;
                    elsif ChrR_Cnt = 3 or ChrR_Cnt = 4 or ( ChrR_Cnt = 5 and ( Hor_Cnt >= 40 or Hor_Cnt < 12 ) ) then
                        SYNC <= vsync2;
                    else
                        SYNC <= vsync1;
                    end if;
                    
                end if;
            
                if ChrC_Cnt = 0 then
                    if Ver_Cnt = 31 and ChrR_Cnt = 0 and Hor_Cnt(5 downto 3) = "000" then
                        INT <= '0';
                    else
                        INT <= '1';
                    end if;

                end if;
                
                ChrC_Cnt <= ChrC_Cnt + 1;
            end if;
            
            Tick <= not Tick;
        end if;
    end process;

    process( CLK )
    begin
        if CLK = '1' then 
            if Paper = '0' then
            
                if Hor_Cnt(0) = '0' then

                    if ChrC_Cnt = 3 and Tick = '0' then
                        wait_sync <= '0';
                    elsif ChrC_Cnt = 5 and Tick = '0' then
                        VideoRead <= '0';
                        VideoRead1 <= '0';
                    elsif ChrC_Cnt = 6 and Tick = '0' then
                        VideoRead2 <= '0';
                        -- set vram address
                        VA <= std_logic_vector( "0" & Ver_Cnt(4 downto 3) & ChrR_Cnt & Ver_Cnt(2 downto 0) & Hor_Cnt(4 downto 0) );
                    elsif ChrC_Cnt = 6 and Tick = '1' then
                        Shift <= VD;
                        -- read data from vram
                        VA <= std_logic_vector( "0110" & Ver_Cnt(4 downto 0) & Hor_Cnt(4 downto 0) );
                    elsif ChrC_Cnt = 7 and Tick = '0' then
                        -- read data from vram
                        Attr <= VD; 
                        -- set vram address lines to high-imp state
                        VA <= ( others => 'Z' );
                    end if;
                    
                end if;

                if Hor_Cnt(0) = '1' then

                    if ChrC_Cnt = 1 and Tick = '1' then
                        VideoRead2 <= '0';
                        -- set vram address
                        VA <= std_logic_vector( "0" & Ver_Cnt(4 downto 3) & ChrR_Cnt & Ver_Cnt(2 downto 0) & Hor_Cnt(4 downto 0) );
                    elsif ChrC_Cnt = 2 and Tick = '0' then
                        -- read data from vram
                        Shift <= VD;
                        -- set vram address
                        VA <= std_logic_vector( "0110" & Ver_Cnt(4 downto 0) & Hor_Cnt(4 downto 0) );
                    elsif ChrC_Cnt = 2 and Tick = '1' then
                        -- read data from vram
                        Attr <= VD; 
                        -- set vram address lines to high-imp state
                        VA <= ( others => 'Z' );
                        VideoRead1 <= '1';
                    elsif ChrC_Cnt = 3 and Tick = '1' then
                        VideoRead2 <= '1';
                        VideoRead <= '1';
                    
                    elsif ChrC_Cnt = 7 and Tick = '0' then
                        wait_sync <= '1';

                    end if;
                    
                end if;

            end if;             

        end if;
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
            if Tick = '1' then
                if paper_r = '0' then           
                    if( Shift_r(7) xor ( Attr_r(7) and Invert(3) ) ) = '1' then
                        B <= Attr_r(0);
                        R <= Attr_r(1);
                        G <= Attr_r(2);
                    else
                        B <= Attr_r(3);
                        R <= Attr_r(4);
                        G <= Attr_r(5);
                    end if;
                else
                    if blank_r = '0' then
                        B <= 'Z';
                        R <= 'Z';
                        G <= 'Z';
                    else
                        B <= BorderAttr(0);
                        R <= BorderAttr(1);
                        G <= BorderAttr(2);
                    end if;
                end if;
            end if;             

        end if;
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
            if Tick = '1' then

                if Paper_r = '0' and Attr_r(6) = '1' then
                        BB <= 'Z';
                        BR <= 'Z';
                        BG <= 'Z';
                else
                        BB <= '0';
                        BR <= '0';
                        BG <= '0';
                end if;

            end if;             

        end if;
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
            if Tick = '1' then
                if ChrC_Cnt = 7 then
                    Attr_r <= Attr;
                    Shift_r <= Shift;

                    if Hor_Cnt(5 downto 2) = 10 or Hor_Cnt(5 downto 2) = 11 or Ver_Cnt = 31 then
                        blank_r <= '0';
                    else 
                        blank_r <= '1';
                    end if;
                    
                    paper_r <= paper;
                else
                    Shift_r(7 downto 1) <= Shift_r(6 downto 0);
                    Shift_r(0) <= '0';
                end if;

            end if;
        end if;
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
            if Tick = '1' and VideoRead = '1' then      
                if (IOREQ or WR) = '0' and VA(7 downto 0) = "11111110" then
                    BorderAttr <= D(2 downto 0);
                    --TAPE_OUT <= D(3);
--                    SOUND_OUT <= D(4);
-- xor SOUND;
--                    SOUND <= SOUND xor SOUND_OUT;
                end if;
            end if;             

        end if;
    end process;

    process( CLK )
    begin
        if CLK'event and CLK = '1' then
            if Tick = '1' and VideoRead = '1' then
--and TRDOS_CHG = '0' then
--                if TRDOS_CHG = '1' and AVR_PORT = '0' and AVR_WAIT = '1' then
                if TRDOS_CHG = '1' then
                    TRDOS_CHG <= '0';
                elsif TRDOS_IN = '1' or TRDOS_OUT = '1' then
--M1 = '0' and RD = '0' and MREQ = '0' and A14 = '0' and A15 = '0' and TRDOS_FLG = '0' and VA(13 downto 8) = "111101"  then
--                    TRDOS_FLG <= '1';
--                    AVR_PORT <= '0';
                    TRDOS_CHG <= '1'; -- clock to cpu is now stopped
--                elsif TRDOS_CHG = '1' and AVR_PORT = '0' and AVR_WAIT = '1' then
--                    TRDOS_CHG <= '0';
                    --   AVR   -    -  FLASH-   
--                elsif M1 = '0' and RD = '0' and MREQ = '0' and (A14 or A15) = '1' and TRDOS_FLG = '1' then
--                    TRDOS_FLG <= '0';
--                    TRDOS_CHG <= '1';
--                    AVR_PORT <= '0';
                elsif IOREQ = '0' and RD = '0' and VA(7 downto 0) = "11111110" and AVR_NOINT = '1' then
                    AVR_PORT <= '0';
                elsif IOREQ = '0' and VA(7 downto 0) = "00011111" and ( RD = '0' or WR = '0' ) then
                    AVR_PORT <= '0';
                else --TRDOS_CHG = '0' then
                    AVR_PORT <= '1';
--                    TRDOS_CHG <= '0';
                end if;
                TRDOS_FLG <= TRDOS_FLG xor TRDOS_CHG;
--            elsif Tick = '1' and VideoRead = '1' and TRDOS_CHG = '1' then
--              TRDOS_CHG <= '0';
            end if;
        end if;
    end process;

end;
